<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Staf extends Model 
{

    protected $table = 'staf';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('full_name', 'user_id', 'opd_id');
    protected $visible = array('full_name', 'user_id');

    public function getProject()
    {
        return $this->hasMany('Project');
    }

    public function getUser()
    {
        return $this->hasOne('App\Task\User');
    }

    public function getOpd()
    {
        return $this->hasOne('App\Models\Task\Opd');
    }

}